`` Script Check 1.2
`` (c) 2007-2012 Scriptol.com
`` Free under the GNU GPL 3 license.
`` Requires the PHP interpreter.
`` and Scriptol to PHP compiler version 7.0 to compile the source.
``
`` Verify that all the scripts or webpages with scripts inside
`` are exactly the same as the original files in the source directory.
`` And so detect malicious code to be stored on the website.
``

include "path.sol"
include "dirlist.sol"
include "ftp.sol"

boolean CHECKMODE = false   // True for virtual operations
boolean VERBOSE = false   // True to display more details
boolean QUIET = false     // True to display nothing
boolean DEBUG = false     // even more verbose

text server = "" 	// The ftp address
text source = ""	// local directory at start
text user = ""		// login
text pass = ""		  // password
array params = {}
text backdir = ""  // backup directory or drive

int connection = 0	// handler
int counter       // Number of files checked
int problem       // Number of files that differ or extra files
int obtrusive      // Number of script not in the original directory   


array validExtensions = { ".php", ".php3", ".php4", ".php5", ".asp", ".aspx"}
//*** you may have to extend this list depending the configuration of the server


file log

void display(text t)
    if not QUIET 
        print t
    /if        
    log.write(t + "\n")
return


// FTP functions

boolean syncConnect()
	connection = ftp_connect(server)
	if connection = 0 let die("Not connected")
	
	if ftp_login(connection, user, pass) = true
		print "Connected on $server as $user" 
		if ftp_pasv(connection, true) = true
		  print "Passive mode turned on"
		else
      print "Enable to set passive mode"
    /if    
		return true
	else	
		print "Enable to connect as $user on $server"
	/if
return false

void syncDisconnect()
	ftp_close(connection)
return

// Comparing

boolean remoteIdentical(text lfile, text rfile)
  if DEBUG = true let display("Comparing $lfile and remote $rfile")
  text temporary = "temporary-file.000.tmp"
	if ftp_get(connection, temporary, rfile, $(FTP_BINARY)) != true 
     print "Enable to load ", rfile
     return false
  /if    
  
  if filesize(temporary) = 0 return true // not existing is ignored	
	
  array x, y
	x.load(lfile)
  if x.size() = 0
     print "Empty file ", lfile
  /if
	y.load(temporary)
  if x.size() = 0
     print "Empty file ", rfile     
  /if

  if (x.size() = 0) and (y.size() = 0) return true

  text a, b

  array x1
  scan x
    a = trim(x[])
    if a <> nil let x1.push(a)
  /scan  
  
  array y1
  scan y
    a = trim(y[])
    if a <> nil let y1.push(a)
  /scan  

  if x1.size() <> y1.size() return false

	scan y1, x1
	   if x1[] <> y1[]
        print "line ", x1[], " ", y[] 
        return false
     /if   
	/scan
	
return true


// Checking

void check(text locdir, text hostdir)

	DirList dlist
	array content = dlist.getList(locdir)
	array distant
	text src, bck, rmt
	boolean returned
	text pname, fname
	
	if content.empty() return
	
	// comparing scripts and  HTML container files
	
	for text name in content
		src = Path.merge(locdir, name)
		if name = "." continue
		if name = ".." continue
		if filetype(src) = "file"
		  text ext = Path.getExtension(src)
		  if ext not in validExtensions continue
		  
		  text result = ("Processing $src")
		  rmt = Path.merge(hostdir, name)

      // system files such as .htaccess are ignored         
      if name[0] = "."     
		     result + " skipped"
		     display(result)
             continue 
		  /if
        
      // compare  
      returned = remoteIdentical(src, rmt)
      if returned = false 
         result + " and $rmt *DIFFER*"
         problem + 1
         display(result)
         continue
      /if  
      counter + 1
      result + " OK"
      if VERBOSE let display(result)
		/if
	/for

	// recursively process of subdirs
	
	for text name in content
		src = Path.merge(locdir, name)	
		if filetype(src) = "dir"
			check(src, Path.merge(hostdir, name))
		/if
	/for	
	
	distant = @ftp_nlist(connection, hostdir)
  if distant = nil
     die("Enable to connect")
  /if
	if VERBOSE print "Dir $locdir sizes =", content.size(), "$hostdir =", distant.size()
	
	for text t in distant
       if t = nil continue
       pname, fname = Path.splitFile(t)
       if fname = "." continue
       if fname = ".." continue
	     if fname in content continue
	     if fname = nil let fname = pname
       obtrusive + 1
       display( "UNKNOWN - $t not in source" )
	/for

return


void usage()
	print
	print "Script Check - (c) 2007-2012 Scriptol.com"
	print "-----------------------------------------"
	print "Syntax:"
	print "  solp scheck [options] sourcedir ftpadr"
	print "Options:"
	print "  -v verbose, display more infos."
	print "  -q quiet, display nothing."	
	print "  -ppassword."
	print "  -llogin."
	print "  -ddirectory"
	print "Arguments:"
	print "  sourcedir: the local directory of original contents."
	print "  ftpadr: remote adr in ftp.domain.tld form (ex: ftp.scriptol.com)."
	exit(0)
return


// Command line parameters parser

void processCommand(int argnum, array arguments)
  
  text daystring = ""
	text opt
	text remotedir = ""

	if argnum <  2
		usage()
	/if	

	for text param in arguments
		if param.length() > 1
			opt = param[..1]
		else
			usage()
		/if	
		
		if opt = "-v" 
			VERBOSE = true
			continue
		/if	

		if opt = "-q" 
			QUIET = true
			continue
		/if	

		if opt = "-u" 
			DEBUG = true
			continue
		/if
    
		if opt = "-p"
			pass = param[ 2 .. ]
			if pass = nil let die("-p must be followed by the password.")
			continue
		/if	

		if opt = "-l"
			user = param[ 2 .. ]
			if user = nil let die("-l must be followed by the login.")			
			continue
		/if

		if opt = "-d" 
			remotedir = param[ 2 .. ]
			if remotedir = nil let die("-d requires a sub-directory.")
			continue
		/if	

		if opt = "-f" 
			server = param[ 2 .. ]
			if server = nil let die("-f requires a sub-directory.")
			continue
		/if	
   	
		if param[ .. 3] = "ftp."
			server = param
			continue
		/if	
		
		if param[0] = "-" 
            print "Unknown command $param"  
            usage()
        /if   
		
		if source = nil
			source = param
			continue
		/if	
		
		print "Unknown command $param"
    
        usage()
		
	/for

	if server = nil input "FTP location: ",  server
	if server = nil let exit(0)

	if source = nil input "Original directory: ",  source
	if source = nil let exit(0)

	if user = nil input "Login: ",  user
	if user = nil let exit(0)

	if pass = nil input "Password: ", pass	
	if pass = nil let exit(0)
	
	params["server"] = server
	params["user"] = user
	params["pass"] = pass
	params["source"] = source
	params["remdir"] = remotedir

return


int main(int argc, array argv)

	array x = argv[ 1 .. ]
	
	processCommand(argc, x)

    problem = 0
    counter = 0
    obtrusive = 0
    server = params["server"]
    user = params["user"]
    pass = params["pass"]
    source = params["source"]
  
    if not QUIET
        if VERBOSE = true print "Verbose mode enabled"
        if DEBUG = true print "Debug mode enabled"
        print "Source directory $source"
        print "Remote directory", params["remdir"]
    /if

    log = fopen("scheck.log", "w")
	syncConnect()
	
	display("Checking $source on $server")
	check(source, params["remdir"])		
	
	syncDisconnect()
	
	display("$counter file" + plural(counter) + " compared.")
	display("$problem file" + plural(problem) + " differ.")
	display("$obtrusive file" + plural(obtrusive) + " obtrusive.")
    log.close()
	
return 0

main($argc, $argv)
